<?php
/**
 * Stop Following
 *
 * @package     AutomatorWP\Integrations\BuddyBoss\Triggers\Stop_Following
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyBoss_Stop_Following extends AutomatorWP_Integration_Trigger {

    public $integration = 'buddyboss';
    public $trigger = 'buddyboss_stop_following';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User stops following someone', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>stops following</strong> someone', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User stops following someone %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User stops following someone', 'automatorwp-pro' ),
            'action'            => 'bp_stop_following',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param object $follow Follow object.
     */
    public function listener( $follow ) {

        $user_id = $follow->follower_id;

        // Trigger the stop following
        automatorwp_trigger_event( array(
            'trigger'       => $this->trigger,
            'user_id'       => $user_id,
        ) );

    }

}

new AutomatorWP_BuddyBoss_Stop_Following();